/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.SoundSource;

public class FileReader
implements SoundSource {
    public static final int BUFFER_SIZE = 256;
    private FileInputStream fileInputStream;
    private Logger logger;

    public FileReader(String fileName, Logger logger) {
        this.logger = logger;
        try {
            this.fileInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.error("file not found: " + fileName, e);
        }
    }

    public synchronized void close() {
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                this.logger.error("io exception", e);
            }
            this.fileInputStream = null;
        }
    }

    @Override
    public synchronized byte[] readData() {
        if (this.fileInputStream == null) {
            return null;
        }
        byte[] buffer = new byte[256];
        try {
            if (this.fileInputStream.read(buffer) >= 0) {
                Thread.sleep(15L);
                return buffer;
            }
            this.fileInputStream.close();
            this.fileInputStream = null;
        }
        catch (IOException e) {
            this.logger.error("io exception", e);
        }
        catch (InterruptedException e) {
            this.logger.debug("file reader interrupted");
        }
        return null;
    }
}

